<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Autoplaying Backdrops with English Logos and Posters</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            position: relative;
            height: 100vh;
            background-color: #222;
            display: flex;
            justify-content: center;
            align-items: center;
            color: white; /* Change text color to white */
        }
        #backdrop {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .logo-container {
            position: absolute;
            top: 25px;
            right: 20px;
            z-index: 1;
            padding: 20px;
            background-color: rgba(5, 0, 5, 0.5);
            border-radius: 50px;
            display: flex;
            flex-direction: column;
            align-items: center;
            width: 300px; /* Fixed width for the logo container */
        }
        .logo {
            max-width: 100%;
            margin-bottom: 20px;
        }
        .poster {
            max-width: 0%;
            margin-bottom: 25px;
        }
        .movie-info {
            color: white;
            text-align: center;
            max-height: 400px; /* Set maximum height for movie info */
            overflow-y: auto; /* Enable vertical scrolling if content exceeds maximum height */
            width: 100%; /* Set a specific width */
            margin-top: 0px;
            padding: 10px;
            border: 6px solid rgba(255, 255, 255, 0.5); /* Add border for clarity */
            border-radius: 30px; /* Add border radius for better appearance */
        }
    </style>
</head>
<body>
    <img id="backdrop">
    <div class="logo-container">
        <img id="logo" class="logo">
        <img id="poster" class="poster">
        <div id="movie-info" class="movie-info"></div>
    </div>

    <script>
        const apiKey = '6b8e3eaa1a03ebb45642e9531d8a76d2'; // Replace with your TMDB API key

        async function fetchTrendingMovies() {
            let trendingMovies = [];
            try {
                for (let i = 1; i <= 50; i++) { // Fetch 50 pages of trending movies
                    const response = await fetch(`https://api.themoviedb.org/3/trending/movie/week?api_key=${apiKey}&page=${i}`);
                    if (!response.ok) {
                        throw new Error(`Failed to fetch trending movies on page ${i}`);
                    }
                    const data = await response.json();
                    trendingMovies = trendingMovies.concat(data.results);
                }
                return trendingMovies.filter(movie => movie.original_language === 'en'); // Filter English movies
            } catch (error) {
                console.error('Error fetching trending movies:', error);
                return [];
            }
        }

        async function fetchOldMovies() {
            let oldMovies = [];
            try {
                for (let i = 1; i <= 50; i++) { // Fetch 50 pages of old movies
                    const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc&primary_release_year=1990&page=${i}`);
                    if (!response.ok) {
                        throw new Error(`Failed to fetch old movies on page ${i}`);
                    }
                    const data = await response.json();
                    oldMovies = oldMovies.concat(data.results);
                }
                return oldMovies.filter(movie => movie.original_language === 'en'); // Filter English movies
            } catch (error) {
                console.error('Error fetching old movies:', error);
                return [];
            }
        }

        async function fetchBackdrop(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}/images?api_key=${apiKey}`);
                if (!response.ok) {
                    throw new Error('Failed to fetch movie images');
                }
                const data = await response.json();
                const backdrops = data.backdrops;
                if (backdrops.length > 0) {
                    // Returning the first backdrop image
                    return 'https://image.tmdb.org/t/p/original' + backdrops[0].file_path;
                }
            } catch (error) {
                console.error('Error fetching backdrop for movie ID ' + movieId + ':', error);
            }
            return null;
        }

        async function fetchLogo(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}/images?api_key=${apiKey}`);
                if (!response.ok) {
                    throw new Error('Failed to fetch movie images');
                }
                const data = await response.json();
                const logos = data.logos.filter(logo => logo.iso_639_1 === 'en'); // Filter English logos
                if (logos.length > 0) {
                    // Returning the first logo image
                    return 'https://image.tmdb.org/t/p/w500' + logos[0].file_path;
                }
            } catch (error) {
                console.error('Error fetching logo for movie ID ' + movieId + ':', error);
            }
            return null;
        }

        let currentIndex = 0;
        let trendingMovies = [];
        let oldMovies = [];

        async function updateBackdrop() {
            if (trendingMovies.length === 0) {
                trendingMovies = await fetchTrendingMovies();
            }
            if (oldMovies.length === 0) {
                oldMovies = await fetchOldMovies();
            }

            const allMovies = trendingMovies.concat(oldMovies);
            const movie = allMovies[currentIndex];
            const backdropUrl = await fetchBackdrop(movie.id);
            if (backdropUrl) {
                const backdrop = document.getElementById('backdrop');
                backdrop.src = backdropUrl;
            }

            // Update movie info
            const movieInfo = document.getElementById('movie-info');
            movieInfo.textContent = `Title: ${movie.title} | Release Date: ${movie.release_date} | Rating: ${movie.vote_average} | Overview: ${movie.overview}`;

            // Update logo
            const logoUrl = await fetchLogo(movie.id);
            if (logoUrl) {
                const logo = document.getElementById('logo');
                logo.src = logoUrl;
                logo.style.display = 'block'; // Show the logo
            } else {
                // If logo is not available, hide the logo element
                const logo = document.getElementById('logo');
                logo.style.display = 'none';
            }

            currentIndex = (currentIndex + 1) % allMovies.length;
        }

        function updateBackdropAndLogo() {
            updateBackdrop();
            // Code to update logo and other information goes here
        }

        setInterval(updateBackdropAndLogo, 6000); // Change backdrop, logo, and movie info every 6 seconds (adjust as needed)
        updateBackdropAndLogo(); // Initial update
    </script>
</body>
</html>
